//
//  UIView+FUCommon.h
//  FUCommonModule
//
//  Created by 刘保健 on 2021/12/8.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef struct FUCornerRadii {
    CGFloat topLeft;
    CGFloat topRight;
    CGFloat bottomLeft;
    CGFloat bottomRight;
} FUCornerRadii;
CG_EXTERN FUCornerRadii FUCornerRadiiMake(CGFloat topLeft, CGFloat topRight, CGFloat bottomLeft, CGFloat bottomRight);

@interface UIView (FUCommon)

@property (nonatomic) CGFloat fu_left;        ///< Shortcut for frame.origin.x.
@property (nonatomic) CGFloat fu_top;         ///< Shortcut for frame.origin.y
@property (nonatomic) CGFloat fu_right;       ///< Shortcut for frame.origin.x + frame.size.width
@property (nonatomic) CGFloat fu_bottom;      ///< Shortcut for frame.origin.y + frame.size.height
@property (nonatomic) CGFloat fu_width;       ///< Shortcut for frame.size.width.
@property (nonatomic) CGFloat fu_height;      ///< Shortcut for frame.size.height.
@property (nonatomic) CGFloat fu_centerX;     ///< Shortcut for center.x
@property (nonatomic) CGFloat fu_centerY;     ///< Shortcut for center.y
@property (nonatomic) CGPoint fu_origin;      ///< Shortcut for frame.origin.
@property (nonatomic) CGSize  fu_size;        ///< Shortcut for frame.size.

/// 部分圆角
/// @param bounds 尺寸
/// @param radius 圆角大小
/// @param rectCorners 圆角位置
- (void)cornerWithBounds:(CGRect)bounds radius:(CGFloat)radius rectCorners:(UIRectCorner)rectCorners;

/// 不同大小的圆角
/// @param bounds 尺寸
/// @param cornerRadii 每个位置圆角大小
- (void)cornerWithBounds:(CGRect)bounds cornerRadii:(FUCornerRadii)cornerRadii;

/// 不同大小的圆角+边框
/// @param bounds 尺寸
/// @param cornerRadii 每个位置圆角大小
/// @param borderColor 边框颜色
/// @param borderWidth 边框宽度
- (void)cornerWithBounds:(CGRect)bounds cornerRadii:(FUCornerRadii)cornerRadii borderColor:(UIColor *)borderColor borderWidth:(CGFloat)borderWidth;

@end

NS_ASSUME_NONNULL_END
