//
//  FUModuleInfo.h
//  FUCommonModule
//
//  Created by 刘保健 on 2021/11/29.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// 业务参数错误码【自定义】
static int parametersErrorCode = 777777;
/// 业务执行错误码【自定义】
static int executeErrorCode = 999999;
/// 道具在itemList中不存在的错误码【自定义】
static int notExistInItemListErrorCode = 888888;

typedef void(^FUToolVoidBlock)(void);

@interface FUTool : NSObject

+ (void)normalLog:(NSString *)message;
+ (void)warningLog:(NSString *)message;
+ (void)errorLog:(NSString *)message;

+ (void)calculateTimeWithMessage:(NSString *)message operateBlock:(FUToolVoidBlock)operateBlock;
+ (NSString *)moduleVersionWithName:(NSString *)moduleName;
+ (UIWindow *)keyWindow;

+ (BOOL)isExist:(NSString *)filePath;
+ (BOOL)createPath:(NSString *)filePath;
+ (BOOL)removeFile:(NSString *)filePath;
+ (BOOL)renamePath:(NSString *)filePath newPath:(NSString *)newPath;
+ (BOOL)saveContainer:(id)container toPath:(NSString *)toPath;

+ (NSArray *)assembleDirectoryNamesWithPath:(NSString *)path;
+ (NSArray *)assembleAvatarIdsWithPath:(NSString *)path;

+ (NSError *)errorWithCode:(int)code message:(NSString *)message;
+ (NSString *)errorMessage:(NSError *)error;

/// 截取URL中的参数
/// @param urlStr 链接
+ (NSMutableDictionary *)getURLParameters:(NSString *)urlStr;

@end

NS_ASSUME_NONNULL_END
