//
//  FUResourceManager.h
//  FUAvatarX
//
//  Created by 刘保健 on 2023/2/20.
//

#import <Foundation/Foundation.h>
#import "FUResourceFactoryProtocol.h"
#import "FUResourceManageConfig.h"
#import "FUAvatarModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^FUResourceKitCompletion)(NSError * _Nullable error);

@interface FUResourceKit : NSObject

/// 所有的AvatarModels
@property (nonatomic, strong, readonly) NSArray<FUAvatarModel *> *avatarModels;

+ (instancetype)sharedManager;

/// 销毁释放单例对象
+ (void)destroy;

/// 设置配置信息【⚠️使用前需先设置】
/// @param config 配置信息
/// @param resourceLoader 资金加载器
- (void)setupWithConfig:(FUResourceManageConfig *)config resourceLoader:(id <FUResourceFactoryProtocol>)resourceLoader;

/// 根据配置加载Avatar
/// @param completion 操作完成后的形象列表回调
- (void)getAvatarListWithCompletion:(void (^)(NSArray<FUAvatarModel *> *avatarModels))completion;

/// 批量加载道具
/// @param sourceIds 道具sourceId（相对路径）集合
/// @param progress 下载进度
/// @param completion 下载结果回调
- (void)getSourceRemoteWithSourceIds:(NSArray *)sourceIds
                            progress:(nullable FUResourceFactoryProgressBlock)progress
                          completion:(FUResourceFactoryCompletion)completion;

/// 加载Avatar 的基础道具【如需更新会自动更新，且会隐藏itemList中不存在的道具】
/// @param avatarModel avatar模型
/// @param progress 加载进度
/// @param completion 结果回调
- (void)loadAvatarBaseItemsWithAvatarModel:(FUAvatarModel *)avatarModel
                                  progress:(nullable FUResourceFactoryProgressBlock)progress
                                completion:(FUResourceKitCompletion)completion;

/// 保存 Avatar模型到沙盒中
/// @param avatarModel Avatar模型
- (BOOL)saveAvatarModel:(FUAvatarModel *)avatarModel;

/// 删除Avatar模型
- (BOOL)deleteAvatarModel:(FUAvatarModel *)avatarModel;

@end

NS_ASSUME_NONNULL_END
