//
//  FUResourceFactoryProtocol.h
//  FUAvatarX
//
//  Created by 刘保健 on 2023/2/22.
//

#ifndef FUResourceFactoryProtocol_h
#define FUResourceFactoryProtocol_h
#import <Foundation/Foundation.h>
#import "FUDownloadResultModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^FUResourceFactoryProgressBlock)(NSString *progress);
typedef void(^FUResourceFactoryCompletion)(FUDownloadResultModel *resultModel);

@protocol FUResourceFactoryProtocol <NSObject>

/// 批量加载道具
/// @param sourceIds 道具sourceId（相对路径）集合
/// @param progress 下载进度
/// @param completion 下载结果回调
- (void)getSourceRemoteWithSourceIds:(NSArray *)sourceIds
                            progress:(nullable FUResourceFactoryProgressBlock)progress
                          completion:(FUResourceFactoryCompletion)completion;
@end

NS_ASSUME_NONNULL_END

#endif /* FUResourceFactoryProtocol_h */
