//
//  FUNetworking.h
//  FUAvatarX
//
//  Created by 刘保健 on 2022/3/23.
//

#import <Foundation/Foundation.h>
#import "FUMultipartFormModel.h"
#import "FUCommonHeader.h"

NS_ASSUME_NONNULL_BEGIN

@interface FUNetworking : NSObject

/// 请求超时时间【⚠️要在 FUNetworking 单例对象初始化前设置，默认60s】
@property (nonatomic, assign, class) int timeoutForRequest;

/// 下载超时时间【⚠️要在 FUNetworking 单例对象初始化前设置，默认60s】
@property (nonatomic, assign, class) int timeoutForDownload;

/// 打印接口响应信息
@property (nonatomic, assign, class) BOOL showResponseLog;

+ (instancetype)sharedInstance;

/// 销毁释放 FUNetworking 单例对象
+ (void)destroy;

/// GET请求
/// @param urlString 请求URL
/// @param parameters 请求参数
/// @param success 成功回调
/// @param failure 失败回调
- (NSURLSessionTask *)getWithURL:(NSString *)urlString
                      parameters:(nullable NSDictionary *)parameters
                         success:(FUSuccessBlock)success
                         failure:(FUFailureBlock)failure;

/// POST请求
/// @param urlString 请求URL
/// @param parameters 请求参数
/// @param success 成功回调
/// @param failure 失败回调
- (NSURLSessionTask *)postWithURL:(NSString *)urlString
                       parameters:(NSDictionary *)parameters
                          success:(FUSuccessBlock)success
                          failure:(FUFailureBlock)failure;

/// MULTIPART 表单请求
/// @param urlString 请求URL
/// @param parameters 请求参数
/// @param formModels FUMultipartFormModel 模型数组
/// @param success 成功回调
/// @param failure 失败回调
- (NSURLSessionTask *)multipartWithURL:(NSString *)urlString
                            parameters:(NSDictionary *)parameters
                            formModels:(NSArray <FUMultipartFormModel *>*)formModels
                               success:(FUSuccessBlock)success
                               failure:(FUFailureBlock)failure;

/// UPLOAD 请求
/// @param urlString 请求URL
/// @param fileData 二进制文件
/// @param success 成功回调
/// @param failure 失败回调
- (NSURLSessionUploadTask *)uploadFileWithURL:(NSString *)urlString
                                     fileData:(NSData *)fileData
                                      success:(FUSuccessBlock)success
                                      failure:(FUFailureBlock)failure;

/// DOWNLOAD请求
/// @param urlString 请求URL
/// @param directoryPath 保存文件路径（默认为Documents路径）
/// @param fileName 保存文件名
/// @param success 成功回调
/// @param failure 失败回调
- (NSURLSessionDownloadTask *)downloadWithURL:(NSString *)urlString
                                directoryPath:(nullable NSString *)directoryPath
                                     fileName:(nullable NSString *)fileName
                                      success:(FUSuccessBlock)success
                                      failure:(FUFailureBlock)failure;

/// DOWNLOAD请求
/// @param urlString 请求URL
/// @param directoryPath 保存文件路径（默认为Documents路径）
/// @param fileName 保存文件名
/// @param progress 下载进度
/// @param success 成功回调
/// @param failure 失败回调
- (NSURLSessionDownloadTask *)downloadWithURL:(NSString *)urlString
                                directoryPath:(nullable NSString *)directoryPath
                                     fileName:(nullable NSString *)fileName
                                     progress:(nullable FUProgressBlock)progress
                                      success:(FUSuccessBlock)success
                                      failure:(FUFailureBlock)failure;

/// 取消指定URL的请求
/// @param urlString 请求URL
- (void)cancelHttpRequestWithURL:(NSString *)urlString;

/// 取消所有HTTP请求
- (void)cancelAllHttpRequests;

@end

NS_ASSUME_NONNULL_END
