//
//  FUFaceTrackResultModel.h
//  FUAvatarX
//
//  Created by lsh726 on 2023/3/13.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, FUFaceTrackInfoType) {
    FUFaceTrackInfoTypePerfect = 0,            // 人脸完美可用
    FUFaceTrackInfoTypeWithoutFace = 10000,    // 未识别到人脸
    FUFaceTrackInfoTypeMultiple,               // 存在多张人脸
    FUFaceTrackInfoTypeRotationError,          // 人脸角度不合规
    FUFaceTrackInfoTypeNotCentered,            // 人脸不居中
    FUFaceTrackInfoTypeExaggeratedExpression,  // 人脸有夸张表情
    FUFaceTrackInfoWithoutProcess,             // 面驱配置未设置
    FUFaceTrackInfoLoadProcessFailed,          // 面驱配置加载失败
};


NS_ASSUME_NONNULL_BEGIN
/**
 * source - Any 原始数据, CVPixelBuffer or FUImageBuffer
 * isCompliant - BOOL 是否合规
 * code - String 提示标识
 * message - String 提示信息
 * size: 图像大小
 */
@interface FUFaceTrackResultModel : NSObject
@property (nonatomic, strong) id source;
@property (nonatomic, assign) BOOL isCompliant;
@property (nonatomic, assign) FUFaceTrackInfoType code;
@property (nonatomic, copy) NSString *message;
@property (nonatomic, assign) CGSize size;
//@property (nonatomic, strong) UIImage *image;
@end

NS_ASSUME_NONNULL_END
