//
//  FUCustomColor.h
//  FUCommonModule
//
//  Created by 刘保健 on 2021/11/29.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum _FUUIColorCompareType {
    FUExtendColorCompareTypeUnEqual,
    FUExtendColorCompareTypeLess,
    FUExtendColorCompareTypeEqual,
    FUExtendColorCompareTypeGreater
} FUExtendColorCompareType;

@interface FUCustomColor : NSObject

@property (nonatomic, assign, readonly) float r;
@property (nonatomic, assign, readonly) float g;
@property (nonatomic, assign, readonly) float b;
@property (nonatomic, assign, readonly) float intensity;

+ (NSArray<FUCustomColor *> *)createFromDicArray:(NSArray<NSDictionary*> *)array;
+ (NSArray<FUCustomColor *> *)createFromColorArray:(NSArray<UIColor*> *)array;

- (FUCustomColor *)initWithRed:(float)red green:(float)green blue:(float)blue intensity:(float)intensity;
- (FUCustomColor *)initWithColor:(UIColor *)color;
- (FUCustomColor *)initWithDic:(NSDictionary *)dic;

- (FUExtendColorCompareType)compare:(FUCustomColor *)color;

+ (UIColor *)colorWithRGBValue:(uint32_t)rgbValue;
+ (UIColor *)colorWithHexStr:(NSString *)hexStr;
+ (UIColor *)colorWithHexStr:(NSString *)hexStr alpha:(float)alpha;
- (UIColor *)color;

@end

NS_ASSUME_NONNULL_END
