//
//  FUCloudService.h
//  FUPTAG
//
//  Created by 刘保健 on 2022/1/6.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIImage.h>
#import "FUCloudServiceConfig.h"
#import "FUMultipartFormModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^FUCloudServiceRemoveIconsBlock)(NSArray *iconUrls);
typedef void(^FUCloudServiceProgressBlock)(NSString *progress);
typedef void(^FUCloudServiceCompletion)(NSError * _Nullable error);
typedef void(^FUCloudServiceResultCompletion)(NSError * _Nullable error, id _Nullable result);
typedef void(^FUCloudServiceDownloadCompletion)(NSError * _Nullable error, NSArray *successFileIds, NSArray *failFileIds);

typedef NS_ENUM(NSInteger, FUCloudGenerateAvatarType) {
    FUCloudGenerateAvatarTypeAuto = -1,   // 自动识别
    FUCloudGenerateAvatarTypeMale = 0,    // 男
    FUCloudGenerateAvatarTypeFemale = 1,  // 女
};

@interface FUCloudService : NSObject

/// 云平台接口访问令牌
@property (nonatomic, readonly) NSString *token;

/// 资源下载后保存的根路径
@property (nonatomic, readonly) NSString *downloadRootPath;

/// 以item 的 path为key，信息为value的所有道具信息字典
@property (nonatomic, readonly) NSMutableDictionary *resourceInfoDic;

/// 需要从图片缓存中移除图片的回调
@property (nonatomic, copy) FUCloudServiceRemoveIconsBlock removeIconsBlock;

/// 下载默认形象
@property (nonatomic, assign) BOOL isDownloadDefaultAvatars;

+ (instancetype)sharedService;

/// 销毁释放 FUCloudService 单例对象
+ (void)destroy;

/// 根据配置对象初始化云平台能力 【⚠️所有云平台接口调用前需配置】
/// @param config 配置对象
/// @param downloadRootPath 下载文件的保存根路径
- (void)setupWithConfig:(FUCloudServiceConfig *)config downloadRootPath:(NSString *)downloadRootPath;

/// 获取云平台 Token
/// @param completion 结果回调
- (void)getTokenWithCompletion:(nullable FUCloudServiceResultCompletion)completion;

/// 获取云平台最新的配置信息
/// @param version 版本号
/// @param completion 结果回调
- (void)getLatestCloudConfigWithVersion:(NSString *)version completion:(nullable FUCloudServiceCompletion)completion;

/// 获取UI配置的配置信息
/// @param version 版本号
/// @param completion 结果回调
- (void)getUIListConfigWithVersion:(NSString *)version completion:(nullable FUCloudServiceResultCompletion)completion;

/// 批量下载云平台道具
/// @param cloudSourceIds 道具 resourceId 数组
/// @param progress 下载进度
/// @param completion 结果回调
- (void)downloadItemsWithCloudSourceIds:(NSArray *)cloudSourceIds
                               progress:(nullable FUCloudServiceProgressBlock)progress
                             completion:(nullable FUCloudServiceDownloadCompletion)completion;

/// 云平台在线生成Avatar
/// @param image Avatar 生成时的参照图片
/// @param type 生成Avatar的类型
/// @param callBackTaskId 设置为YES，completion中是 TaskId; 设置为NO，completion中是 avatarJson字符串
/// @param completion 结果回调
- (void)generateAvatarOnlineWithImage:(UIImage *)image
                                 type:(FUCloudGenerateAvatarType)type
                       callBackTaskId:(BOOL)callBackTaskId
                           completion:(FUCloudServiceResultCompletion)completion;

/// 通过taskId来获取avatarJson
/// @param taskId 获取avatatrJson资源的id
/// @param completion 结果回调
- (void)getTaskInfoWithTaskId:(NSString *)taskId
                   completion:(FUCloudServiceResultCompletion)completion;

/// 保存Avatar信息到云平台
/// @param avatarPath Avatar.json的根路径
/// @param completion 结果回调
- (void)uploadAvatarInfoWithAvatarPath:(NSString *)avatarPath completion:(FUCloudServiceResultCompletion)completion;

/// 保存Avatar信息到云平台
/// @param formModelArray 数据表单
/// @param completion 结果回调
- (void)uploadAvatarInfoWithFormModelArray:(NSArray<FUMultipartFormModel *> *)formModelArray completion:(FUCloudServiceResultCompletion)completion;

/// 云平台在线获取Avatar
/// @param avatarId id（口令）
/// @param completion 结果回调
- (void)getAvatarOnlineWithAvatarId:(NSString *)avatarId completion:(FUCloudServiceResultCompletion)completion;

/// 所有道具的信息保存路径
- (NSString *)pathOfResourceInfoJson;

/// 下载保存后的所有avatar信息的根路径
- (NSString *)avatarRootPath;

/// 下载保存后的某一个avatar.json 的根路径
/// @param avatarName avatar名称
- (NSString *)avatarPathWithName:(NSString *)avatarName;

/// 文件状态键值
- (NSString *)fileStateKey;

@end

NS_ASSUME_NONNULL_END
