//
//  FUBuilderKit.h
//  FUAvatarX
//
//  Created by 刘保健 on 2023/2/20.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "FUCloudService.h"
#import "FUTrackFaceFilter.h"
#import "FUBuilderConfig.h"
#import <FURenderKit/FURenderIO.h>

typedef NS_ENUM(NSInteger, FUAIFaceProcessorDetectMode) {
    FUAIFaceProcessorDetectModeImage, //图像
    FUAIFaceProcessorDetectModeVideo, //视频
};


NS_ASSUME_NONNULL_BEGIN

typedef void(^FUBuilderKitCompletion)(NSError * _Nullable error, id _Nullable result);

@interface FUBuilderKit : NSObject

/**
 * 生成模块的一些数据配置
 */
+ (instancetype)setupWithConfig:(FUBuilderConfig *)config;


/** 获取脸部信息的检测结果
 * @param pixelBuffer 图像数据类
 * filters 检测顺序会根据数组里面的顺序排序，一旦检测到不符合的结果会直接返回, 忽略后续的filter
 * @return 检测结果
 * */
- (FUFaceTrackResultModel *)traceFaceWithPiexelBuffer:(CVPixelBufferRef)pixelBuffer
                                           detectMode:(FUAIFaceProcessorDetectMode)detectMode
                                              filters:(NSArray<FUTrackFaceFilter *> *)filters;


/** 获取脸部信息的检测结果
 * @param imageBuffer 自定图像数据类
 * filters 检测顺序会根据数组里面的顺序排序，一旦检测到不符合的结果会直接返回, 忽略后续的filter
 * @return 检测结果
 * */
- (FUFaceTrackResultModel *)traceFaceWithImageBuffer:(FUImageBuffer)imageBuffer
                                          detectMode:(FUAIFaceProcessorDetectMode)detectMode
                                             filters:(NSArray<FUTrackFaceFilter *> *)filters;


/** 根据图片和性别生成 Avatar.json信息
 * @param image 图片
 * @param type 生成Avatar的类型
 * @param completion 结果回调
 */
- (void)buildAvatarWithImage:(UIImage *)image type:(FUCloudGenerateAvatarType)type completion:(FUBuilderKitCompletion)completion;

@end

NS_ASSUME_NONNULL_END
