//
//  FUAvatarModel.h
//  FUAvatarEditorDemo
//
//  Created by liuyang on 2021/5/26.
//

#import <Foundation/Foundation.h>
#import <FURenderKit/FUAvatar.h>

typedef enum : NSUInteger {
    FUAvatarGenderMale, // 男性
    FUAvatarGenderFemale, // 女性
} FUAvatarGender;

NS_ASSUME_NONNULL_BEGIN

@interface FUAvatarModel : NSObject

/// 名称
@property (nonatomic, copy) NSString *name;

/// AvatarId
@property (nonatomic, copy) NSString *avatarId;

/// avatar.json 文件的根路径
@property (nonatomic, copy) NSString *avatarPath;

/// Avatar的图标
@property (nonatomic, strong) UIImage *iconImage;

/// Avatar的性别
@property (nonatomic, assign) FUAvatarGender gender;

/// 模型中的 Avatar
@property (nonatomic, strong, readonly) FUAvatar *avatar;

/// 根据性别生成的过滤条件 @{@"gender" :  @"male"}  或者 @{@"gender" :  @"female"}
@property (nonatomic, strong) NSDictionary *genderFilter;

/// 是否已经根据 avatarJson加载过基础道具
@property (nonatomic, assign) BOOL addedBaseComponents;

/// 根据名称和 avatar.json 文件的根路径初始化
/// @param name 名称
/// @param avatarPath avatar.json 文件的根路径
- (instancetype)initWithName:(NSString *)name avatarPath:(NSString *)avatarPath;

/// 根据 avatarJson 初始化
/// @param avatarJson avatarJson字符串
- (instancetype)initWithAvatarJson:(NSString *)avatarJson;

/// 克隆一份当前的 AvatarModel
- (instancetype)clone;

/// 克隆其他的 AvatarModel中的信息
/// @param otherAvatarModel 其他的 AvatarModel
- (void)cloneAvatarModel:(FUAvatarModel *)otherAvatarModel;

/// 获取Avatar.json中的道具
- (NSArray <NSString *> *)avatarJsonFileIds;

/// 保存头像
- (void)saveIconImage;

/// 销毁内部的 FUAvatar对象
- (void)destroyAvatar;

@end

NS_ASSUME_NONNULL_END
