//
//  FUPathsHelper.h
//  FUAvatarX
//
//  Created by 刘保健 on 2022/8/12.
//

#import <Foundation/Foundation.h>
#import <FURenderKit/FUAvatar.h>

NS_ASSUME_NONNULL_BEGIN

@interface FUAvatarHelper : NSObject

/// controller_config.bundle 的路径
@property (nonatomic, copy) NSString *controllerConfigPath;

/// 动画的graph配置文件路径
@property (nonatomic, copy) NSString *animationGraphPath;

/// 动画的logic配置文件路径
@property (nonatomic, copy) NSString *animationLogicPath;

/// 默认道具配置文件路径
@property (nonatomic, copy) NSString *defaultJsonPath;

/// 默认道具路径集合
@property (nonatomic, readonly) NSArray <NSString *> *defaultFileIds;

+ (instancetype)shareHelper;

/// 加载本地的 default 道具【为后续的Avatar加载做准备】
/// @param paths 道具的绝对路径集合
/// @return YES加载成功，NO加载失败
+ (BOOL)loadDefaultBundleWithPaths:(NSArray <NSString *> *)paths;

/// 创建 FUAvatar对象
+ (FUAvatar *)createAvatar;

/// 获取道具的meta文件路径
/// @param bundlePath 道具路径
+ (NSString *)metaPath:(NSString *)bundlePath;

/// 销毁 shareCenter
+ (void)destroy;

@end

NS_ASSUME_NONNULL_END
