//
//  FUAvatarEditor.h
//  FUAvatarX
//
//  Created by 刘保健 on 2023/2/20.
//

#import <Foundation/Foundation.h>
#import <FURenderKit/FURenderKit.h>
#import "FUAvatarEditProtocol.h"
//#import "FUAvatarModel.h"

typedef FUColor FUColorRGBAData;

NS_ASSUME_NONNULL_BEGIN

@interface FUAvatarEditorKit : NSObject

/**
 * 需要编辑的avatar形象
 */
@property (nonatomic, strong, nonnull) FUAvatar *avatar;

/**
 * 设置颜色
 * @param key 颜色对应的key
 * @param color 颜色值
 */
- (void)setColor:(FUColorRGBAData)color forKey:(nonnull NSString *)key;

/**
 * 设置某个捏形维度（channel）的系数，原则上范围是0~1，但是如果效果能接受，小于0或者大于1都是可以运行的
 * @param key String 骨骼捏形Key
 * @param intensity Float 强度
 */
- (void)setDeformation:(double)intensity forKey:(nonnull NSString *)key;

/**
 * 更新Avatar道具
 * @param newComponents 新道具数组
 * @param oldComponents 旧道具名称数组
 */
- (void)updateComponentsWithNewComponents:(NSArray<FUItem *> *)newComponents oldComponents:(NSArray<NSString *> *)oldComponents;

@end

NS_ASSUME_NONNULL_END
